/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpManager.Admin.IBMNMAList;
import ibm.nways.analysis.dpManager.Admin.NetworkDisplay;
import ibm.nways.analysis.dpManager.Admin.NetworkNode;
import ibm.nways.analysis.dpManager.DPEDirectory;
import ibm.nways.analysis.dpManager.DPERange;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.NhmHelpRef;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;

public class DPEConfig
extends Panel
implements JCItemListener,
TextListener,
JCActionListener,
ItemListener {
    private BorderLayout bLayout = new BorderLayout();
    private ColumnLayout cLayout = new ColumnLayout(10);
    private JCGridLayout gLayout = new JCGridLayout(1, 3, 20, 10);
    private Applet appl;
    private NetworkDisplay ND;
    private Panel titlePanel;
    private Panel column1;
    private Panel column2;
    private Panel column3;
    private Panel add_remPanel;
    private Canvas blankCanvas1;
    private JCButton addButton;
    private JCButton removeButton;
    private Label dpeLabel;
    private Panel listPanel;
    private Label listLabel;
    private IBMNMAList rangesList;
    private Panel ok_cancelPanel;
    private JCButton okayButton;
    private JCButton cancelButton;
    private JCButton helpButton;
    private Panel configPanel;
    private Label label1;
    private TextField textField1;
    private Label label2;
    private Canvas blankCanvas2;
    private TextField textField2;
    private Label label3;
    private Label label4;
    private Panel choicePanel;
    private JCCheckboxGroup configChoices;
    private JCCheckbox checkBox1;
    private JCCheckbox checkBox2;
    private JCCheckbox checkBox3;
    private InetAddress inetAddress;
    private String dpeName;
    private DPERange dpeRange;
    private DPEDirectory dpeDirCopy;
    private Panel gridPanel;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String CONFIG_BOX_TITLE = adminRB.getString("s_CMode");
    private static final String IP_CHECK_BOX_TITLE = adminRB.getString("s_ByIP");
    private static final String IPRANGE_CHECK_BOX_TITLE = adminRB.getString("s_ByIPRange");
    private static final String SUBNET_CHECK_BOX_TITLE = adminRB.getString("s_BySubnet");
    private static final String SUBNET_TEXTFIELD_LABEL = adminRB.getString("s_SubMask");
    private static final String IPADDRESS_TEXTFIELD_LABEL = adminRB.getString("s_IPAdd");
    private static final String IPRANGE_TEXTFIELD1_LABEL = adminRB.getString("s_StRange");
    private static final String IPRANGE_TEXTFIELD2_LABEL = adminRB.getString("s_EndRange");
    private static final String ADD_BUTTON_LABEL = adminRB.getString("s_Add");
    private static final String REM_BUTTON_LABEL = adminRB.getString("s_Remove");
    private static final String OK_BUTTON_LABEL = adminRB.getString("s_Ok");
    private static final String CANCEL_BUTTON_LABEL = adminRB.getString("s_Cancel");
    private static final String HELP_BUTTON_LABEL = adminRB.getString("s_Help");
    private int SUBNET_CONFIG;
    private int IP_CONFIG;
    private int IPRANGE_CONFIG;

    public DPEConfig(NetworkDisplay networkDisplay, Applet applet) {
        this.appl = applet;
        this.ND = networkDisplay;
        this.setLayout(this.bLayout);
        this.listPanel = new Panel(this.cLayout);
        this.listLabel = new Label(adminRB.getString("s_ExistingRanges"));
        this.rangesList = new IBMNMAList(12, true);
        this.rangesList.addItemListener(this);
        this.listPanel.add(this.listLabel);
        this.listPanel.add(this.rangesList);
        this.add_remPanel = new Panel();
        this.add_remPanel.setLayout(this.cLayout);
        this.dpeLabel = new Label();
        this.titlePanel = new Panel();
        this.titlePanel.add(this.dpeLabel);
        this.addButton = new JCButton(ADD_BUTTON_LABEL);
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.removeButton = new JCButton(REM_BUTTON_LABEL);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.add_remPanel.add(this.addButton);
        this.add_remPanel.add(this.removeButton);
        this.configChoices = new JCCheckboxGroup(CONFIG_BOX_TITLE);
        this.checkBox1 = new JCCheckbox(IP_CHECK_BOX_TITLE);
        this.checkBox2 = new JCCheckbox(IPRANGE_CHECK_BOX_TITLE);
        this.checkBox3 = new JCCheckbox(SUBNET_CHECK_BOX_TITLE);
        this.configChoices.add(this.checkBox1);
        this.configChoices.add(this.checkBox2);
        this.configChoices.setRadioBehavior(true);
        this.configChoices.addItemListener(this);
        this.configPanel = new Panel();
        this.configPanel.setLayout(this.cLayout);
        this.label1 = new Label(SUBNET_TEXTFIELD_LABEL);
        this.label2 = new Label(IPRANGE_TEXTFIELD1_LABEL);
        this.label3 = new Label(IPRANGE_TEXTFIELD2_LABEL);
        this.label4 = new Label(IPADDRESS_TEXTFIELD_LABEL);
        this.textField1 = new TextField(12);
        this.textField1.addTextListener(this);
        this.textField2 = new TextField(12);
        this.textField2.addTextListener(this);
        this.blankCanvas2 = new Canvas();
        this.blankCanvas2.setSize(10, 55);
        this.ipConfiguration();
        this.column1 = new Panel();
        this.column1.setLayout(this.cLayout);
        this.column1.add(this.configPanel);
        this.column2 = new Panel();
        this.column2.setLayout(this.cLayout);
        this.column2.add(this.add_remPanel);
        this.column3 = new Panel();
        this.column3.setLayout(this.cLayout);
        this.column3.add(this.listPanel);
        this.gridPanel = new Panel();
        this.gridPanel.setLayout(this.gLayout);
        this.gridPanel.add(this.column1);
        this.gridPanel.add(this.column2);
        this.gridPanel.add(this.column3);
        this.ok_cancelPanel = new Panel();
        this.okayButton = new JCButton(OK_BUTTON_LABEL);
        this.okayButton.setEnabled(false);
        this.cancelButton = new JCButton(CANCEL_BUTTON_LABEL);
        this.helpButton = new JCButton(HELP_BUTTON_LABEL);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.ok_cancelPanel.add(this.okayButton);
        this.ok_cancelPanel.add(this.cancelButton);
        this.ok_cancelPanel.add(this.helpButton);
        this.add("North", this.titlePanel);
        this.add("Center", this.gridPanel);
        this.add("South", this.ok_cancelPanel);
    }

    public void ipConfiguration() {
        this.configPanel.removeAll();
        this.configPanel.add(this.label4);
        this.configPanel.add(this.textField1);
        this.configPanel.add(this.blankCanvas2);
        this.configPanel.add(this.configChoices);
        this.IP_CONFIG = 1;
        this.SUBNET_CONFIG = 0;
        this.IPRANGE_CONFIG = 0;
    }

    public void rangeConfiguration() {
        this.configPanel.removeAll();
        this.configPanel.add(this.label2);
        this.configPanel.add(this.textField1);
        this.configPanel.add(this.label3);
        this.configPanel.add(this.textField2);
        this.configPanel.add(this.configChoices);
        this.IPRANGE_CONFIG = 1;
        this.IP_CONFIG = 0;
        this.SUBNET_CONFIG = 0;
    }

    public void subnetConfiguration() {
        this.configPanel.removeAll();
        this.configPanel.add(this.label1);
        this.configPanel.add(this.textField1);
        this.configPanel.add(this.blankCanvas2);
        this.configPanel.add(this.configChoices);
        this.SUBNET_CONFIG = 1;
        this.IPRANGE_CONFIG = 0;
        this.IP_CONFIG = 0;
    }

    public NetworkDisplay getNDRef() {
        return this.ND;
    }

    public void setDpeName(String string) {
        this.dpeName = string;
        this.dpeLabel.setText(this.dpeName);
        if (this.dpeName.equals(this.ND.getDpAdminRef().getServerName())) {
            this.textField1.setEditable(false);
            this.textField2.setEditable(false);
            this.checkBox1.setEnabled(false);
            this.checkBox2.setEnabled(false);
            this.checkBox3.setEnabled(false);
        }
    }

    public void setDpeRanges(String string, DPEDirectory dPEDirectory) {
        this.dpeDirCopy = dPEDirectory;
        this.dpeDirCopy.getDPERanges();
        this.updateDpeRangesListBox(string);
    }

    public void updateDpeRangesListBox(String string) {
        this.rangesList.removeAll();
        this.removeButton.setEnabled(false);
        Vector vector = this.dpeDirCopy.getDPERanges(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            DPERange dPERange = (DPERange)enumeration.nextElement();
            String string3 = dPERange.toListString();
            String string4 = this.getStartRange(string3);
            if (string4.equals(string2 = this.getEndRange(string3))) {
                this.rangesList.addItem(string4);
                continue;
            }
            this.rangesList.addItem(string3);
        }
    }

    public void addConfiguration(String string, String string2) {
        if (string2 == null) {
            if (string != null) {
                ((TextComponent)this.textField1).setText("");
                string = this.ND.giveHostNameGetIp(string);
                this.dpeRange = new DPERange(this.dpeName, string, string);
                this.dpeDirCopy.addDPEbyRange(this.dpeRange);
                this.updateDpeRangesListBox(this.dpeName);
            }
        } else {
            ((TextComponent)this.textField1).setText("");
            ((TextComponent)this.textField2).setText("");
            if (string != null) {
                this.dpeRange = new DPERange(this.dpeName, string, string2);
                this.dpeDirCopy.addDPEbyRange(this.dpeRange);
                this.updateDpeRangesListBox(this.dpeName);
            }
        }
        this.addButton.setEnabled(false);
        String[] stringArray = this.rangesList.getSelectedItems();
        if (stringArray == null || stringArray.length == 0) {
            this.removeButton.setEnabled(false);
        }
    }

    public String getStartRange(String string) {
        String string2 = null;
        string2 = string.substring(0, string.indexOf(" "));
        return string2;
    }

    public String getEndRange(String string) {
        String string2 = null;
        int n = string.length();
        string2 = string.substring(string.indexOf("-") + 2, n);
        return string2;
    }

    public void removeConfiguration(String string) {
        String string2 = null;
        String string3 = null;
        if (string != null) {
            if (string.indexOf("-") == -1) {
                string2 = string;
                string3 = string;
            } else {
                string2 = this.getStartRange(string);
                string3 = this.getEndRange(string);
            }
            this.dpeRange = new DPERange(this.dpeName, string2, string3);
            this.dpeDirCopy.removeDPEbyRange(this.dpeRange);
            this.updateDpeRangesListBox(this.dpeName);
        }
        if (this.rangesList.getItemCount() == 0) {
            this.removeButton.setEnabled(false);
        }
    }

    public static boolean validHostname(String string) {
        boolean bl = true;
        string.trim();
        if (string.length() == 0) {
            bl = false;
        }
        return bl;
    }

    public static long convertStringToAddress(String string) throws NumberFormatException {
        boolean bl = true;
        long l = 0L;
        string.trim();
        if (string.length() == 0) {
            bl = false;
        } else {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (bl && stringTokenizer.hasMoreTokens()) {
                if (++n > 4) {
                    bl = false;
                    continue;
                }
                String string2 = stringTokenizer.nextToken();
                try {
                    int n2 = Integer.parseInt(string2);
                    if (n2 < 0 || n2 > 255) {
                        bl = false;
                        continue;
                    }
                    l = (long)((double)l + (double)n2 * Math.pow(2.0, 32 - 8 * n));
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            if (n < 4) {
                bl = false;
            }
        }
        if (!bl) {
            throw new NumberFormatException();
        }
        return l;
    }

    public void textValueChanged(TextEvent textEvent) {
        long l = 0L;
        long l2 = 0L;
        if (this.IPRANGE_CONFIG == 1) {
            try {
                l = DPEConfig.convertStringToAddress(this.textField1.getText());
                l2 = DPEConfig.convertStringToAddress(this.textField2.getText());
                if (l < l2) {
                    this.addButton.setEnabled(true);
                    return;
                }
                this.addButton.setEnabled(false);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.addButton.setEnabled(false);
                return;
            }
        }
        if (this.IP_CONFIG == 1) {
            if (DPEConfig.validHostname(this.textField1.getText())) {
                this.addButton.setEnabled(true);
                return;
            }
            this.addButton.setEnabled(false);
            return;
        }
        if (this.SUBNET_CONFIG == 1) {
            try {
                l = DPEConfig.convertStringToAddress(this.textField1.getText());
                this.addButton.setEnabled(true);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.addButton.setEnabled(false);
                return;
            }
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.addButton) {
            this.okayButton.setEnabled(true);
            if (this.IP_CONFIG == 1) {
                String string = null;
                string = this.textField1.getText();
                this.addConfiguration(string, null);
                return;
            }
            if (this.SUBNET_CONFIG == 1) {
                String string = null;
                string = this.textField1.getText();
                this.addConfiguration(string, null);
                return;
            }
            if (this.IPRANGE_CONFIG == 1) {
                String string = null;
                string = this.textField1.getText();
                String string2 = null;
                string2 = this.textField2.getText();
                this.addConfiguration(string, string2);
                return;
            }
        } else {
            if (jCActionEvent.getSource() == this.removeButton) {
                this.okayButton.setEnabled(true);
                String[] stringArray = this.rangesList.getSelectedItems();
                int n = 0;
                while (n < stringArray.length) {
                    this.removeConfiguration(stringArray[n]);
                    ++n;
                }
                this.removeButton.setEnabled(false);
                return;
            }
            if (jCActionEvent.getSource() == this.cancelButton) {
                this.updateDpeRangesListBox(this.dpeName);
                ((TextComponent)this.textField1).setText("");
                ((TextComponent)this.textField2).setText("");
                this.okayButton.setEnabled(false);
                this.ND.showDpeTop();
                return;
            }
            if (jCActionEvent.getSource() == this.okayButton) {
                NetworkNode networkNode = this.ND.getDpeTopRef().getCanvas().getDraggedNode();
                if (networkNode != null) {
                    this.ND.getDpeTopRef().createAssignedNetworkNode(networkNode.getNodeLabel());
                    this.ND.getDpeTopRef().adjustUnAssNodeStorage(networkNode);
                    this.ND.getDpeTopRef().getCanvas().setDraggedNode();
                }
                try {
                    this.ND.getDpAdminRef().getAdminInterface().updateDPEConfig(this.dpeDirCopy);
                    this.updateDpeRangesListBox(this.dpeName);
                    ((TextComponent)this.textField1).setText("");
                    ((TextComponent)this.textField2).setText("");
                    this.okayButton.setEnabled(false);
                    this.ND.showDpeTop();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (jCActionEvent.getSource() == this.helpButton) {
                NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
                if (this.appl instanceof BrowserApplet) {
                    BrowserApplet browserApplet = (BrowserApplet)this.appl;
                    browserApplet.showHelp(nhmHelpRef);
                    return;
                }
                this.appl.getAppletContext().showDocument(nhmHelpRef.getURL(this.appl));
            }
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        this.itemStateChanged((ItemEvent)jCItemEvent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.checkBox1 && itemEvent.getID() == 701) {
            if (itemEvent.getStateChange() == 1) {
                this.configPanel.invalidate();
                this.ipConfiguration();
                this.column1.validate();
                this.textValueChanged(new TextEvent(this.textField1, 900));
                return;
            }
        } else if (itemEvent.getSource() == this.checkBox2 && itemEvent.getID() == 701) {
            if (itemEvent.getStateChange() == 1) {
                this.configPanel.invalidate();
                this.rangeConfiguration();
                this.column1.validate();
                this.textValueChanged(new TextEvent(this.textField1, 900));
                return;
            }
        } else if (itemEvent.getSource() == this.checkBox3 && itemEvent.getID() == 701) {
            if (itemEvent.getStateChange() == 1) {
                this.configPanel.invalidate();
                this.subnetConfiguration();
                this.column1.validate();
                this.textValueChanged(new TextEvent(this.textField1, 900));
                return;
            }
        } else if (itemEvent.getSource() == this.rangesList && itemEvent.getID() == 701) {
            if (itemEvent.getStateChange() == 1) {
                if (!this.dpeName.equals(this.ND.getDpAdminRef().getServerName())) {
                    this.removeButton.setEnabled(true);
                    return;
                }
            } else {
                String[] stringArray = this.rangesList.getSelectedItems();
                if (stringArray == null || stringArray.length == 0) {
                    this.removeButton.setEnabled(false);
                }
            }
        }
    }
}

